(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20710,        525]*)
(*NotebookOutlinePosition[     21362,        548]*)
(*  CellTagsIndexPosition[     21318,        544]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \(\(nube = {{1, 1}, {2, 1.7}, {3, 0.7}, {4, 1}};\)\), "\n", 
    \(p[x_] = InterpolatingPolynomial[nube, x]\)}], "Input"],

Cell[BoxData[
    \(1 + \((\(\(0.7`\)\(\[InvisibleSpace]\)\) + \((\(-0.85`\) + 
                  0.5`\ \((\(-3\) + x)\))\)\ \((\(-2\) + x)\))\)\ \((\(-1\) + 
            x)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[p[x]]\)], "Input"],

Cell[BoxData[
    \(\(-4.4`\) + 8.75`\ x - 3.85`\ x\^2 + 0.5`\ x\^3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = 
      Plot[p[x], {x, 0.8, 4.3}, AspectRatio \[Rule] Automatic, 
        PlotStyle \[Rule] {Thickness[0.004]}, 
        PlotRange \[Rule] {\(-0.1\), 2.6}, 
        Ticks \[Rule] {{{0.8, 0}, {1.8, 1}, {3.42, 2}}, {}}, 
        AxesStyle \[Rule] {Thickness[0.004]}, AxesLabel \[Rule] {t\ , \ s}, 
        AxesOrigin \[Rule] {0.8, p[0.8]}, 
        TextStyle \[Rule] {FontSlant \[Rule] "\<Italic\>", 
            FontSize \[Rule] 25}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .73469 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.193878 0.272109 0.0272109 0.272109 [
[.29592 .12138 -9.5 -28.875 ]
[.29592 .12138 9.5 0 ]
[.73673 .12138 -9.5 -28.875 ]
[.73673 .12138 9.5 0 ]
[1.025 .13388 0 -14.4375 ]
[1.025 .13388 19 14.4375 ]
[.02381 .75969 -9.5 0 ]
[.02381 .75969 9.5 28.875 ]
[ -0.002 -0.002 0 0 ]
[ 1.002 .73669 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.29592 .13388 m
.29592 .14013 L
s
gsave
.29592 .12138 -70.5 -32.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 36.875 translate 1 -1 scale
63.000 25.188 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 25.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.73673 .13388 m
.73673 .14013 L
s
gsave
.73673 .12138 -70.5 -32.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 36.875 translate 1 -1 scale
63.000 25.188 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 25.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.004 w
0 .13388 m
1 .13388 L
s
gsave
1.025 .13388 -61 -18.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 36.875 translate 1 -1 scale
63.000 25.188 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 25.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 0 m
.02381 .73469 L
s
gsave
.02381 .75969 -70.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 36.875 translate 1 -1 scale
63.000 25.188 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 25.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(s) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .73469 L
0 .73469 L
closepath
clip
newpath
.02381 .13388 m
.06244 .25689 L
.10458 .36064 L
.12507 .4005 L
.14415 .43182 L
.16371 .45841 L
.18221 .47868 L
.20262 .49589 L
.2212 .5071 L
.2309 .51136 L
.2362 .51325 L
.24117 .51474 L
.24576 .51588 L
.24995 .51674 L
.25461 .51747 L
.25717 .51778 L
.25962 .51801 L
.26086 .51811 L
.2622 .5182 L
.26339 .51826 L
.26464 .51831 L
.26577 .51834 L
.26702 .51836 L
.26815 .51837 L
.2692 .51836 L
.26984 .51836 L
.27053 .51834 L
.27178 .51831 L
.273 .51826 L
.27413 .5182 L
.2767 .51803 L
.27942 .51777 L
.28393 .51721 L
.28816 .51651 L
.29781 .51434 L
.30764 .51133 L
.31799 .50733 L
.3365 .49818 L
.3746 .47228 L
.41516 .43637 L
.45421 .39615 L
.49571 .35004 L
.53569 .305 L
.57416 .26355 L
.61507 .22408 L
.63543 .20707 L
.65448 .19314 L
.67391 .18119 L
.69237 .17224 L
.70207 .16856 L
Mistroke
.71265 .16541 L
.71731 .16431 L
.72227 .16336 L
.72695 .16265 L
.73119 .16219 L
.73352 .162 L
.73486 .16191 L
.73608 .16185 L
.73737 .1618 L
.73808 .16178 L
.73875 .16176 L
.73994 .16175 L
.74124 .16174 L
.74235 .16175 L
.74357 .16178 L
.74484 .16182 L
.74604 .16187 L
.74817 .162 L
.75047 .16219 L
.75301 .16246 L
.75578 .16283 L
.76135 .16381 L
.76651 .165 L
.77131 .16636 L
.78186 .17024 L
.79181 .17505 L
.81041 .18715 L
.83046 .20501 L
.84892 .22615 L
.88838 .28757 L
.92632 .36944 L
.96671 .48369 L
.97619 .51483 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 211.563},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000daP00`40o`000?l0003o4oooo`030000
oooooooo0?ooool;oooo000Coooo00<0003oooooool0ooooo`_oool001?oool00`000?ooooooo`3o
oooo2oooo`004oooo`030000oooooooo0?ooool;oooo000Coooo00<0003oooooool0ooooo`_oool0
01?oool00`000?ooooooo`3ooooo2oooo`004oooo`030000oooooooo0?ooool;oooo000Coooo00<0
003oooooool0ooooo`_oool001?oool00`000?ooooooo`3ooooo2oooo`004oooo`030000oooooooo
03Woool90000Goooo`X0001Ooooo000Coooo00<0003oooooool0?Oooo`030000oooooooo06;oool0
0`000?ooooooo`05oooo00<0003oooooool0GOooo`004oooo`030000oooooooo03goool00`000?oo
ooooo`1Soooo00<0003oooooool0I?ooo`004oooo`030000oooooooo03koool00`000?ooooooo`1S
oooo00<0003oooooool0Hoooo`004oooo`030000oooooooo03koool00`000?ooooooo`1Toooo0P00
06?oool001?oool00`000?ooooooo`0noooo00<0003oooooool0I_ooo`030000oooooooo063oool0
01?oool00`000?ooooooo`0noooo00<0003oooooool0Ioooo`030000oooooooo05ooool001?oool0
0`000?ooooooo`0noooo00<0003oooooool0J?ooo`030000oooooooo05koool001?oool00`000?oo
ooooo`0ooooo00<0003oooooool0J?ooo`030000oooooooo05goool001?oool00`000?ooooooo`0o
oooo00<0003oooooool0JOooo`030000oooooooo05coool001?oool00`000?ooooooo`0ooooo00<0
003oooooool0J_ooo`030000oooooooo05_oool001?oool00`000?ooooooo`0ooooo00<0003ooooo
ool0J_ooo`030000oooooooo05_oool001?oool00`000?ooooooo`0ooooo00<0003oooooool0H_oo
o`030000oooooooo00Goool00`000?ooooooo`1Koooo000Coooo00<0003oooooool0@?ooo`030000
oooooooo06;oool00`000?ooooooo`04oooo00<0003oooooool0Foooo`004oooo`030000oooooooo
03coool3000000?oool0003oool0I?ooo`030000oooooooo00;oool00`000?ooooooo`1Loooo000C
oooo00<0003oooooool0?oooo`80001Voooo100005ooool001?oool00`000?ooooooo`3ooooo2ooo
o`004oooo`030000oooooooo0?ooool;oooo000Coooo00<0003oooooool0loooo`L0000@oooo000C
oooo00<0003oooooool0loooo`030000oooooooo00Coool00`000?ooooooo`0=oooo000Coooo00<0
003oooooool0loooo`030000oooooooo01Coool001?oool00`000?ooooooo`3coooo00<0003ooooo
ool05?ooo`004oooo`030000oooooooo0??oool00`000?ooooooo`0Doooo000=ooool00000coool0
0`000?ooooooo`0Doooo000Coooo00<0003oooooool0?_ooo`030000oooooooo06Koool00`000?oo
ooooo`19oooo00<0003oooooool05?ooo`004oooo`80000ooooo00<0003oooooool0I_ooo`030000
oooooooo04Woool00`000?ooooooo`0Doooo000Coooo0P000?Goool00`000?ooooooo`0Coooo000C
oooo0P000?Goool00`000?ooooooo`0Coooo000Coooo0P000??oool900003oooo`004oooo`030000
oooo00000?Coool00`000?ooooooo`0Coooo000Coooo00<0003oool00000Xoooo`/00016oooo00<0
003oooooool04oooo`004oooo`030000oooo00000:3oool300002oooo`<00014oooo00<0003ooooo
ool04_ooo`004oooo`040000oooooooo0000Voooo`@0000Aoooo0`00047oool00`000?ooooooo`0B
oooo000Coooo00@0003oooooool0002Joooo00<0003oooooool05_ooo`030000oooooooo05?oool0
01?oool010000?ooooooo`0009Soool200006_ooo`80001Coooo000Coooo00D0003oooooooooool0
0000UOooo`80000Noooo00<0003oooooool0D?ooo`004oooo`050000oooooooooooo000009?oool2
00008Oooo`030000oooooooo04ooool001?oool01@000?ooooooooooo`00002Aoooo0P0002Coool0
0`000?ooooooo`1>oooo000Coooo00D0003oooooooooool00000T?ooo`030000oooooooo02Goool2
0000C_ooo`004oooo`030000oooooooo00;oool00`000?ooooooo`2<oooo00<0003oooooool0:?oo
o`030000oooooooo04_oool001?oool00`000?ooooooo`02oooo00<0003oooooool0Roooo`030000
oooooooo02[oool00`000?ooooooo`1:oooo000Coooo00<0003oooooool00_ooo`030000oooooooo
08[oool00`000?ooooooo`0/oooo00<0003oooooool0BOooo`004oooo`030000oooooooo00?oool0
0`000?ooooooo`28oooo00<0003oooooool0;_ooo`030000oooooooo04Soool001?oool00`000?oo
ooooo`03oooo00<0003oooooool0Q_ooo`80000boooo00<0003oooooool0Aoooo`004oooo`030000
oooooooo00?oool00`000?ooooooo`25oooo00<0003oooooool0<oooo`030000oooooooo04Koool0
01?oool00`000?ooooooo`04oooo00<0003oooooool0Poooo`030000oooooooo03Goool00`000?oo
ooooo`15oooo000Coooo00<0003oooooool01?ooo`030000oooooooo08;oool00`000?ooooooo`0g
oooo00<0003oooooool0A?ooo`004oooo`030000oooooooo00Coool00`000?ooooooo`21oooo00<0
003oooooool0>?ooo`030000oooooooo04Coool001?oool00`000?ooooooo`04oooo00<0003ooooo
ool0P?ooo`030000oooooooo03[oool00`000?ooooooo`13oooo000Coooo00<0003oooooool01Ooo
o`030000oooooooo07koool00`000?ooooooo`0koooo00<0003oooooool0@oooo`004oooo`030000
oooooooo00Goool00`000?ooooooo`1loooo0P0003ooool00`000?ooooooo`12oooo000Coooo00<0
003oooooool01Oooo`030000oooooooo07_oool00`000?ooooooo`10oooo00<0003oooooool0@Ooo
o`004oooo`030000oooooooo00Koool00`000?ooooooo`1ioooo00<0003oooooool0@Oooo`030000
oooooooo047oool001?oool00`000?ooooooo`06oooo00<0003oooooool0N?ooo`030000oooooooo
04?oool00`000?ooooooo`10oooo000Coooo00<0003oooooool01_ooo`030000oooooooo07Ooool0
0`000?ooooooo`14oooo00<0003oooooool0@?ooo`004oooo`030000oooooooo00Ooool00`000?oo
ooooo`1eoooo00<0003oooooool0A_ooo`030000oooooooo03ooool001?oool00`000?ooooooo`07
oooo00<0003oooooool0M?ooo`030000oooooooo04Soool00`000?ooooooo`0noooo000Coooo00<0
003oooooool02?ooo`030000oooooooo07;oool00`000?ooooooo`19oooo00<0003oooooool0?_oo
o`004oooo`030000oooooooo00Soool00`000?ooooooo`1aoooo00<0003oooooool0Boooo`030000
oooooooo03goool001?oool00`000?ooooooo`08oooo00<0003oooooool0LOooo`030000oooooooo
04_oool00`000?ooooooo`0moooo000Coooo00<0003oooooool02Oooo`030000oooooooo06ooool0
0`000?ooooooo`1=oooo00<0003oooooool0??ooo`004oooo`030000oooooooo00Woool00`000?oo
ooooo`1^oooo00<0003oooooool0C_ooo`030000oooooooo03coool001?oool00`000?ooooooo`0:
oooo00<0003oooooool0K?ooo`030000oooooooo053oool00`000?ooooooo`0koooo000Coooo00<0
003oooooool02_ooo`030000oooooooo06_oool00`000?ooooooo`1Aoooo00<0003oooooool0>ooo
o`004oooo`030000oooooooo00_oool00`000?ooooooo`1Yoooo00<0003oooooool0Doooo`030000
oooooooo03[oool001?oool00`000?ooooooo`0;oooo00<0003oooooool0J?ooo`030000oooooooo
05Coool00`000?ooooooo`0joooo000Coooo00<0003oooooool02oooo`030000oooooooo06Ooool0
0`000?ooooooo`1Foooo00<0003oooooool0>Oooo`004oooo`030000oooooooo00coool00`000?oo
ooooo`1Uoooo00<0003oooooool0Eoooo`030000oooooooo03Woool001?oool00`000?ooooooo`0<
oooo00<0003oooooool0I?ooo`030000oooooooo05Woool00`000?ooooooo`0hoooo000Coooo00<0
003oooooool03Oooo`030000oooooooo06;oool00`000?ooooooo`1Joooo00<0003oooooool0>?oo
o`004oooo`030000oooooooo00goool00`000?ooooooo`1Roooo00<0003oooooool0F_ooo`030000
oooooooo03Soool001?oool00`000?ooooooo`0=oooo00<0003oooooool0HOooo`030000oooooooo
05coool00`000?ooooooo`0goooo000Coooo00<0003oooooool03_ooo`030000oooooooo05ooool0
0`000?ooooooo`1Moooo00<0003oooooool0=oooo`004oooo`030000oooooooo00koool00`000?oo
ooooo`1Noooo00<0003oooooool0Goooo`030000oooooooo03Koool001?oool00`000?ooooooo`0?
oooo00<0003oooooool0G?ooo`030000oooooooo063oool00`000?ooooooo`0foooo000Coooo00<0
003oooooool03oooo`030000oooooooo05_oool00`000?ooooooo`1Roooo00<0003oooooool0=Ooo
o`004oooo`030000oooooooo013oool00`000?ooooooo`1Ioooo00<0003oooooool0Hoooo`030000
oooooooo03Goool001?oool00`000?ooooooo`0@oooo00<0003oooooool0F?ooo`030000oooooooo
06Goool00`000?ooooooo`0doooo000Coooo00<0003oooooool04Oooo`030000oooooooo05Ooool0
0`000?ooooooo`1Uoooo00<0003oooooool0=?ooo`004oooo`030000oooooooo017oool00`000?oo
ooooo`1Foooo00<0003oooooool0Ioooo`030000oooooooo03?oool001?oool00`000?ooooooo`0B
oooo00<0003oooooool0E?ooo`030000oooooooo06Soool00`000?ooooooo`0coooo000Coooo00<0
003oooooool04_ooo`030000oooooooo05?oool00`000?ooooooo`1Yoooo00<0003oooooool0<ooo
o`004oooo`030000oooooooo01?oool00`000?ooooooo`1Aoooo00<0003oooooool0Joooo`030000
oooooooo03;oool001?oool00`000?ooooooo`0Coooo00<0003oooooool0D?ooo`030000oooooooo
06coool00`000?ooooooo`0boooo000Coooo00<0003oooooool05?ooo`030000oooooooo04ooool0
0`000?ooooooo`1/oooo00<0003oooooool0<_ooo`004oooo`030000oooooooo01Coool00`000?oo
ooooo`1>oooo00<0003oooooool0K_ooo`030000oooooooo037oool001?oool00`000?ooooooo`0E
oooo00<0003oooooool0C?ooo`030000oooooooo06ooool00`000?ooooooo`0aoooo000Coooo00<0
003oooooool05Oooo`030000oooooooo04_oool00`000?ooooooo`1aoooo00<0003oooooool0<?oo
o`004oooo`030000oooooooo01Koool00`000?ooooooo`19oooo00<0003oooooool0L_ooo`030000
oooooooo033oool001?oool00`000?ooooooo`0Foooo00<0003oooooool0B?ooo`030000oooooooo
07?oool00`000?ooooooo`0`oooo000Coooo00<0003oooooool05oooo`030000oooooooo04Koool0
0`000?ooooooo`1eoooo00<0003oooooool0;oooo`004oooo`030000oooooooo01Soool00`000?oo
ooooo`14oooo00<0003oooooool0M_ooo`030000oooooooo02ooool001?oool00`000?ooooooo`0I
oooo00<0003oooooool0@_ooo`030000oooooooo07Ooool00`000?ooooooo`0_oooo000Coooo00<0
003oooooool06Oooo`030000oooooooo047oool00`000?ooooooo`1ioooo00<0003oooooool0;_oo
o`004oooo`030000oooooooo01[oool00`000?ooooooo`0ooooo00<0003oooooool0N_ooo`030000
oooooooo02koool001?oool00`000?ooooooo`0Koooo00<0003oooooool0?Oooo`030000oooooooo
07coool00`000?ooooooo`0]oooo000Coooo00<0003oooooool06oooo`030000oooooooo03coool0
0`000?ooooooo`1moooo00<0003oooooool0;Oooo`004oooo`030000oooooooo01coool00`000?oo
ooooo`0joooo00<0003oooooool0O_ooo`030000oooooooo02goool001?oool00`000?ooooooo`0L
oooo00<0003oooooool0>Oooo`030000oooooooo083oool00`000?ooooooo`0/oooo000Coooo00<0
003oooooool07Oooo`030000oooooooo03Ooool00`000?ooooooo`21oooo00<0003oooooool0;?oo
o`004oooo`030000oooooooo01goool00`000?ooooooo`0eoooo0P0008Coool00`000?ooooooo`0/
oooo000Coooo00<0003oooooool07_ooo`030000oooooooo03?oool00`000?ooooooo`25oooo00<0
003oooooool0:oooo`004oooo`030000oooooooo01ooool00`000?ooooooo`0aoooo00<0003ooooo
ool0Q_ooo`030000oooooooo02_oool001?oool00`000?ooooooo`0Poooo00<0003oooooool0;ooo
o`030000oooooooo08Soool00`000?ooooooo`0Zoooo000Coooo00<0003oooooool08Oooo`030000
oooooooo02goool00`000?ooooooo`29oooo00<0003oooooool0:_ooo`004oooo`030000oooooooo
02;oool00`000?ooooooo`0Zoooo0P0008coool00`000?ooooooo`0Zoooo000Coooo00<0003ooooo
ool08oooo`030000oooooooo02Ooool20000Soooo`030000oooooooo02Woool001?oool00`000?oo
ooooo`0Toooo00<0003oooooool09Oooo`030000oooooooo08ooool00`000?ooooooo`0Yoooo000C
oooo00<0003oooooool09Oooo`030000oooooooo02;oool20000T_ooo`030000oooooooo02Woool0
01?oool00`000?ooooooo`0Voooo00<0003oooooool07oooo`80002Eoooo00<0003oooooool0:?oo
o`004oooo`030000oooooooo02Ooool200007Oooo`80002Goooo00<0003oooooool0:?ooo`004ooo
o`030000oooooooo02Woool200006Oooo`80002Ioooo00<0003oooooool0:?ooo`004oooo`030000
oooooooo02_oool300005?ooo`80002Koooo00<0003oooooool0:?ooo`004oooo`030000oooooooo
02koool200004?ooo`80002Noooo00<0003oooooool09oooo`004oooo`030000oooooooo033oool3
00002_ooo`<0002Poooo00<0003oooooool09oooo`004oooo`030000oooooooo03?oool:0000cOoo
o`004oooo`030000oooooooo0?ooool;oooo000Coooo00<0003oooooool0ooooo`_oool001?oool0
0`000?ooooooo`3ooooo2oooo`004oooo`030000oooooooo0?ooool;oooo000Coooo00<0003ooooo
ool0ooooo`_oool001?oool00`000?ooooooo`3ooooo2oooo`004oooo`030000oooooooo0?ooool;
oooo000Coooo00<0003oooooool0ooooo`_oool001?oool00`000?ooooooo`3ooooo2oooo`004ooo
o`030000oooooooo0?ooool;oooo000Coooo00<0003oooooool0ooooo`_oool001?oool00`000?oo
ooooo`3ooooo2oooo`004oooo`030000oooooooo0?ooool;oooo000Coooo00<0003oooooool0oooo
o`_oool001?oool00`000?ooooooo`3ooooo2oooo`004oooo`030000oooooooo0?ooool;oooo000C
oooo00<0003oooooool0ooooo`_oool001?oool00`000?ooooooo`3ooooo2oooo`004oooo`030000
oooooooo0?ooool;oooo000Coooo00<0003oooooool0ooooo`_oool001?oool00`000?ooooooo`3o
oooo2oooo`004oooo`030000oooooooo0?ooool;oooo000Coooo00<0003oooooool0ooooo`_oool0
01?oool00`000?ooooooo`3ooooo2oooo`004oooo`030000oooooooo0?ooool;oooo000Coooo00<0
003oooooool0ooooo`_oool001?oool00`000?ooooooo`3ooooo2oooo`004oooo`030000oooooooo
0?ooool;oooo000Coooo00<0003oooooool0ooooo`_oool001?oool00`000?ooooooo`3ooooo2ooo
o`004oooo`030000oooooooo0?ooool;oooo000Coooo00<0003oooooool0ooooo`_oool001?oool0
0`000?ooooooo`3ooooo2oooo`004oooo`030000oooooooo0?ooool;oooo000Coooo00<0003ooooo
ool0ooooo`_oool001?oool00`000?ooooooo`3ooooo2oooo`004oooo`030000oooooooo0?ooool;
oooo000Coooo00<0003oooooool0ooooo`_oool001?oool00`000?ooooooo`3ooooo2oooo`004ooo
o`030000oooooooo0?ooool;oooo000Coooo00<0003oooooool0ooooo`_oool001?oool00`000?oo
ooooo`3ooooo2oooo`004oooo`030000oooooooo0?ooool;oooo000Coooo00<0003oooooool0oooo
o`_oool001?oool00`000?ooooooo`3ooooo2oooo`004oooo`030000oooooooo0?ooool;oooo000C
oooo00<0003oooooool0ooooo`_oool001?oool00`000?ooooooo`3ooooo2oooo`004oooo`030000
oooooooo0?ooool;oooo000Coooo00<0003oooooool0ooooo`_oool001?oool00`000?ooooooo`3o
oooo2oooo`004oooo`030000oooooooo0?ooool;oooo003ooooo8Oooo`00ooooob7oool00?oooolQ
oooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQ
oooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`003Oooo`030000oooo0000
00@0003ooooo3Oooo`003Oooo`800005oooo0P000?ooool;oooo000>oooo00<0003oooooool01Ooo
o`030000oooooooo0?ooool8oooo000Foooo00<0003oooooool0ooooo`Soool001Koool00`000?oo
ooooo`3ooooo2?ooo`004oooo`<0003ooooo2oooo`004Oooo`80003ooooo3_ooo`004?ooo`030000
oooooooo0?ooool>oooo000@oooo00<0003oooooool01?ooo`030000oooooooo0?ooool7oooo000A
oooo00<0003oooooool00oooo`030000oooooooo0?ooool7oooo000Boooo1P000?ooool9oooo003o
oooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003o
oooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {210.563, 0}} -> {0.501984, -0.107364, \
0.0154069, 0.0154069}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<movpt.eps\>", \ %, \ "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{499, 369},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 140, 2, 50, "Input"],
Cell[1882, 55, 189, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2108, 63, 45, 1, 30, "Input"],
Cell[2156, 66, 81, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2274, 72, 468, 9, 130, "Input"],
Cell[2745, 83, 17571, 423, 220, 4802, 261, "GraphicsData", "PostScript", \
"Graphics"],
Cell[20319, 508, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20486, 516, 75, 1, 30, "Input"],
Cell[20564, 519, 130, 3, 29, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

